﻿<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">

    public class Params : ContextBase {

        public Params(Context context): base(context) {
        }

        DefinicjaJęzykaObcego[] języki;
        [Priority(10)]
        public DefinicjaJęzykaObcego[] Języki {
            get { return języki; }
            set {
                języki = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListJęzyki() {
            KadryModule kadry = KadryModule.GetInstance(this);
            Soneta.Business.View v = kadry.DefJezykowObcych.WgNazwy.CreateView();
            v.Condition &= new FieldCondition.NotEqual("Blokada", true);
            return v;
        }                    
        
        DefinicjaStopiaZnajomościJęzykaObcego[] wMowie;
        [Priority(20)]
        public DefinicjaStopiaZnajomościJęzykaObcego[] ZnajomośćWMowie {
            get { return wMowie; }
            set {
                wMowie = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListZnajomośćWMowie() {
            KadryModule kadry = KadryModule.GetInstance(this);
            Soneta.Business.View v = kadry.DefStZnJObcych.WgNazwy.CreateView();
            v.Condition &= new FieldCondition.NotEqual("Blokada", true);
            return v;
        }                    
        
        DefinicjaStopiaZnajomościJęzykaObcego[] wPiśmie;
        [Priority(30)]
        public DefinicjaStopiaZnajomościJęzykaObcego[] ZnajomośćWPiśmie {
            get { return wPiśmie; }
            set {
                wPiśmie = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListZnajomośćWPiśmie() {
            return GetListZnajomośćWMowie();
        }
    }

    [Context]
    public Params Pars {
        set {
            języki = value.Języki;
            wMowie = value.ZnajomośćWMowie;
            wPiśmie = value.ZnajomośćWPiśmie;
        }
    }

    DefinicjaJęzykaObcego[] języki;
    DefinicjaStopiaZnajomościJęzykaObcego[] wMowie;
    DefinicjaStopiaZnajomościJęzykaObcego[] wPiśmie;

    RowCondition condition = RowCondition.Empty;

    protected void dc_ContextLoad(object sender, EventArgs e) {
        ReportHeader["JĘZYKI"] = Info("Język obcy", "Języki obce", języki);
        ReportHeader["MOWA"] = Info("Znajomość w mowie", "Znajomość w mowie", wMowie);
        ReportHeader["PISMO"] = Info("Znajomość w piśmie", "Znajomość w piśmie", wPiśmie);

        if (języki != null && języki.Length > 0)
            condition &= new FieldCondition.In("Jezyk", języki);
        if (wMowie != null && wMowie.Length > 0)
            condition &= new FieldCondition.In("Mowa", wMowie);
        if (wPiśmie != null && wPiśmie.Length > 0)
            condition &= new FieldCondition.In("Pismo", wPiśmie);

        colJęzyk.Visible = języki == null || języki.Length != 1;
        colMowa.Visible = wMowie == null || wMowie.Length != 1;
        colPismo.Visible = wPiśmie == null || wPiśmie.Length != 1;

        bool hidden = !(colJęzyk.Visible | colMowa.Visible | colPismo.Visible);
        if (hidden)
            dc.Landscape = false;
    }

    protected void Grid_BeforeRow(object sender, RowEventArgs args) {
        Pracownik idx = (Pracownik)args.Row;
        SubTable st = idx.Module.ZnJezykowObcych.WgPracownik[idx];
        st = st[condition];

        bool any = false;
        foreach (ZnajomośćJęzykaObcego zjo in st) {
            any = true;
            colJęzyk.AddLine(zjo.Jezyk.Nazwa);
            colMowa.AddLine(zjo.Mowa.Nazwa);
            colPismo.AddLine(zjo.Pismo.Nazwa);
            if (zjo.Zaswiadczenie != "") {
                colRodzaj.AddLine(zjo.Zaswiadczenie);
                colData.AddLine(zjo.DataWydaniaZaswiadczenia);
            }
            else {
                colRodzaj.AddLine();
                colData.AddLine();
            }
        }

        args.VisibleRow = any;
    }

    static string Info(string singleLabel, string multiLabel, params object[] lst) {
        if (lst == null || lst.Length == 0)
            return "";
        else if (lst.Length == 1)
            return string.Format("</strong>|{0}: <strong>{1}", singleLabel, lst[0]);
        string info = "";
        foreach (object obj in lst)
            if (info == "")
                info = obj.ToString();
            else
                info += "</strong>, <strong>" + obj.ToString();
        return string.Format("</strong>|{0}: <strong>{1}", multiLabel, info);
    }

    public static void Msg(object value) {
    }
    
</script>

<HTML>
	<HEAD>
		<TITLE>Znajomość języków obcych</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad" 
                Landscape="True"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" runat="server" 
                title="Znajomość języków obcych|&lt;/strong&gt;Wydział: &lt;strong&gt;{0}|&lt;/strong&gt;Pośrednio: &lt;strong&gt;{1}|&lt;/strong&gt;Okres: &lt;strong&gt;{2}|&lt;/strong&gt;Aktualny: &lt;strong&gt;{3}%JĘZYKI%%MOWA%%PISMO%" 
                DataMember0="KadryPracownicyViewInfo+PrParams.Wydział" 
                DataMember1="KadryPracownicyViewInfo+PrParams.Pośrednio" 
                DataMember2="KadryPracownicyViewInfo+PrParams.Okres" 
                DataMember3="KadryPracownicyViewInfo+PrParams.Aktualny"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" 
                RowTypeName="Soneta.Kadry.Pracownik,Soneta.KadryPlace" 
                onbeforerow="Grid_BeforeRow">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Nazwisko" EncodeHTML="true" Caption="Nazwisko"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Imie" EncodeHTML="true" 
                        Caption="Imie" Width="16" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" DataMember="Kod" EncodeHTML="true" 
                        Caption="Kod" Width="16" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" 
                        DataMember="Workers.Info.Historia.Etat.Wydzial" EncodeHTML="true" 
                        Caption="Wydział" Width="16" NoWrap="True"></ea:GridColumn>
				    <ea:GridColumn ID="colJęzyk" runat="server" Caption="Język obcy" NoWrap="True" 
                        Width="16" VAlign="Top">
                    </ea:GridColumn>
                    <ea:GridColumn ID="colMowa" runat="server" Caption="Znajomość w~mowie" 
                        NoWrap="True" Width="12" VAlign="Top">
                    </ea:GridColumn>
                    <ea:GridColumn ID="colPismo" runat="server" Caption="Znajomość w~piśmie" 
                        NoWrap="True" Width="12" VAlign="Top">
                    </ea:GridColumn>
				    <ea:GridColumn ID="colRodzaj" runat="server" Caption="Certyfikat~nazwa" 
                        NoWrap="True" Width="24" VAlign="Top">
                    </ea:GridColumn>
                    <ea:GridColumn ID="colData" runat="server" Caption="Certyfikat~data wydania" 
                        NoWrap="True" Width="10" VAlign="Top">
                    </ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

